/*
 * Decompiled with CFR 0.152.
 */
package flash.io;

import exploit.control.AppControl;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;

public class BitInput {
    private InputStream myStream;
    private int offset;
    private long register;
    public long bitsRead;
    private boolean isDebug;

    public BitInput(InputStream inputStream) {
        this.myStream = inputStream;
        this.offset = 0;
        this.register = 0L;
        this.bitsRead = 0L;
        this.isDebug = AppControl.getInfo().getDebug();
        if (this.isDebug) {
            System.out.println("Binary Input: Active");
        }
    }

    public void useCompressedStream() {
        this.myStream = new InflaterInputStream(this.myStream);
    }

    public void zipStream() {
        this.myStream = new InflaterInputStream(this.myStream);
    }

    public void close() throws IOException {
        this.myStream.close();
    }

    public int readByte() throws IOException {
        this.offset = 0;
        ++this.bitsRead;
        return this.myStream.read() & 0xFF;
    }

    public int[] readBytes(int n) throws IOException {
        this.offset = 0;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.readByte();
        }
        return nArray;
    }

    public byte[] readBytes2(int n) throws IOException {
        this.offset = 0;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)this.readByte();
        }
        return byArray;
    }

    public int getAlignment() {
        return this.offset;
    }

    private int readInternalByte() throws IOException {
        ++this.bitsRead;
        return this.myStream.read() & 0xFF;
    }

    public void align() throws IOException {
        this.offset = 0;
        this.register = 0L;
    }

    public long readBits(int n, boolean bl) throws IOException {
        int n2;
        if (this.offset == 0) {
            this.register = 0L;
        }
        int n3 = 0;
        long l = 1L;
        long l2 = 0L;
        if (n > this.offset) {
            while (n > this.offset) {
                if (!bl) {
                    n3 = this.readInternalByte();
                    this.register <<= 8;
                    this.register |= (long)n3;
                    this.offset += 8;
                    continue;
                }
                n3 = this.readInternalByte();
                this.register |= (long)(n3 <<= this.offset);
                this.offset += 8;
            }
        }
        l2 = (n2 = this.offset - n) > 0 ? this.register >> n2 : this.register;
        this.offset = n2;
        if (this.offset > 0) {
            l = this.pow(this.offset) - 1L;
            this.register &= l;
        }
        return l2;
    }

    public String printBinary(long l, int n) {
        long l2 = 1L;
        String string = "";
        while (n > 0) {
            string = (l & l2) == l2 ? "1" + string : "0" + string;
            l2 *= 2L;
            --n;
        }
        return string;
    }

    public void skip(long l) throws IOException {
        this.align();
        this.myStream.skip(l);
        this.bitsRead += l;
    }

    public long pow(int n) {
        long l = 1L;
        while (n > 0) {
            l *= 2L;
            --n;
        }
        return l;
    }
}

